/*******************/
/* BagoluC172 Book */
/*******************/
Include.addScript("/JS/dataStorage.js");

/***************************************************************************************************/
class bagoluc172_book extends BaseInstrument {
	constructor() {
		super();
		this.page = 0;
		this.STATE_SAVING_on_off = 0;
		this.STATE_SAVING_save_delay = -1;
		this.STATE_SAVING_load_delay = -1;
		this.STATE_SAVING_onflight_start = 0;
		this.STATE_SAVING_default_load_delay = 25;
		this.STATE_SAVING_default_save_delay = 30;
		this.STATE_SAVING_prefix = "BAGOLUC172M_STSV_"+this.hashCode(SimVar.GetSimVarValue("TITLE", "string"));
		this.radiostack = 0;
		this.radiostackloop = 20;
		this.kap140wait = 1;
		/* Check available updates */
		this.current_version = "0.2.0";
		this.checkLastVersion();
	}
	get templateID() {
		return "bagoluc172_book";
	}
	get isInteractive() {
		return true;
	}
	get IsGlassCockpit() {
	}
	connectedCallback() {
		super.connectedCallback();
		this.BOOK_PAGE0 = this.getChildById("BOOK_PAGE0");
		this.BOOK_PAGE1 = this.getChildById("BOOK_PAGE1");
		this.BOOK_PAGE2 = this.getChildById("BOOK_PAGE2");
		this.BOOK_PAGE9 = this.getChildById("BOOK_PAGE9");
		this.BOOK_PAGE0.style.visibility = "visible";
		this.BOOK_PAGE1.style.visibility = "hidden";
		this.BOOK_PAGE2.style.visibility = "hidden";
		this.BOOK_PAGE9.style.visibility = "hidden";

		/* Bind functions to buttons*/
		this.GOTOPAGEA_Event = this.getChildById("GOTOPAGEA");
		this.GOTOPAGEA_Event.addEventListener("mousedown", this.GOTOPAGEA_Press.bind(this));
		this.GOTOPAGEB_Event = this.getChildById("GOTOPAGEB");
		this.GOTOPAGEB_Event.addEventListener("mousedown", this.GOTOPAGEB_Press.bind(this));
		this.GOTOPAGEZ_Event = this.getChildById("GOTOPAGEZ");
		this.GOTOPAGEZ_Event.addEventListener("mousedown", this.GOTOPAGEZ_Press.bind(this));

		this.HIDE_MANUAL_LOGO_Event = this.getChildById("HIDEMANUALLOGO");
		this.HIDE_MANUAL_LOGO_Event.addEventListener("mousedown", this.HIDE_MANUAL_LOGO_Press.bind(this));
		this.PILOTVISIBLE_Event = this.getChildById("PILOTVISIBLE");
		this.PILOTVISIBLE_Event.addEventListener("mousedown", this.PILOTVISIBLE_Press.bind(this));
		this.COPILOTVISIBLE_Event = this.getChildById("COPILOTVISIBLE");
		this.COPILOTVISIBLE_Event.addEventListener("mousedown", this.COPILOTVISIBLE_Press.bind(this));
		this.LEFTPASSENGER_Event = this.getChildById("LEFTPASSENGER");
		this.LEFTPASSENGER_Event.addEventListener("mousedown", this.LEFTPASSENGER_Press.bind(this));
		this.RIGHTPASSENGER_Event = this.getChildById("RIGHTPASSENGER");
		this.RIGHTPASSENGER_Event.addEventListener("mousedown", this.RIGHTPASSENGER_Press.bind(this));
		this.BACKSEATS_Event = this.getChildById("BACKSEATS");
		this.BACKSEATS_Event.addEventListener("mousedown", this.BACKSEATS_Press.bind(this));
		this.FRONTRIGHTSEAT_Event = this.getChildById("FRONTRIGHTSEAT");
		this.FRONTRIGHTSEAT_Event.addEventListener("mousedown", this.FRONTRIGHTSEAT_Press.bind(this));
		this.FRONTFAIRINGS_Event = this.getChildById("FRONTFAIRINGS");
		this.FRONTFAIRINGS_Event.addEventListener("mousedown", this.FRONTFAIRINGS_Press.bind(this));
		this.BACKFAIRINGS_Event = this.getChildById("BACKFAIRINGS");
		this.BACKFAIRINGS_Event.addEventListener("mousedown", this.BACKFAIRINGS_Press.bind(this));
		this.WHEELCHOCKS_Event = this.getChildById("WHEELCHOCKS");
		this.WHEELCHOCKS_Event.addEventListener("mousedown", this.WHEELCHOCKS_Press.bind(this));
		this.GPU_Event = this.getChildById("GPU");
		this.GPU_Event.addEventListener("mousedown", this.GPU_Press.bind(this));
		this.TIEDOWNS_Event = this.getChildById("TIEDOWNS");
		this.TIEDOWNS_Event.addEventListener("mousedown", this.TIEDOWNS_Press.bind(this));
		this.COVERS_Event = this.getChildById("COVERS");
		this.COVERS_Event.addEventListener("mousedown", this.COVERS_Press.bind(this));
		this.BUTTONSLIST_Event = this.getChildById("BUTTONSLIST");
		this.BUTTONSLIST_Event.addEventListener("mousedown", this.BUTTONSLIST_Press.bind(this));
		this.CARDLIST_Event = this.getChildById("CARDLIST");
		this.CARDLIST_Event.addEventListener("mousedown", this.CARDLIST_Press.bind(this));
		this.STATE_SAVING_Event = this.getChildById("STATESAVING");
		this.STATE_SAVING_Event.addEventListener("mousedown", this.STATE_SAVING_Press.bind(this));
		this.COMPASS0_Event = this.getChildById("COMPASS0");
		this.COMPASS0_Event.addEventListener("mousedown", this.COMPASS0_Press.bind(this));
		this.COMPASS1_Event = this.getChildById("COMPASS1");
		this.COMPASS1_Event.addEventListener("mousedown", this.COMPASS1_Press.bind(this));
		this.COMPASS2_Event = this.getChildById("COMPASS2");
		this.COMPASS2_Event.addEventListener("mousedown", this.COMPASS2_Press.bind(this));
		this.FDGYRO_Event = this.getChildById("FDGYRO");
		this.FDGYRO_Event.addEventListener("mousedown", this.FDGYRO_Press.bind(this));
		this.FDHSI_Event = this.getChildById("FDHSI");
		this.FDHSI_Event.addEventListener("mousedown", this.FDHSI_Press.bind(this));
		this.FDG5_Event = this.getChildById("FDG5");
		this.FDG5_Event.addEventListener("mousedown", this.FDG5_Press.bind(this));
		this.HZSTD_Event = this.getChildById("HZSTD");
		this.HZSTD_Event.addEventListener("mousedown", this.HZSTD_Press.bind(this));
		this.HZG5_Event = this.getChildById("HZG5");
		this.HZG5_Event.addEventListener("mousedown", this.HZG5_Press.bind(this));
		this.AOA_Event = this.getChildById("AOA");
		this.AOA_Event.addEventListener("mousedown", this.AOA_Press.bind(this));
		this.RSVFR_Event = this.getChildById("RSVFR");
		this.RSVFR_Event.addEventListener("mousedown", this.RSVFR_Press.bind(this));
		this.RSRADIOS_Event = this.getChildById("RSRADIOS");
		this.RSRADIOS_Event.addEventListener("mousedown", this.RSRADIOS_Press.bind(this));
		this.RSTDS750_Event = this.getChildById("RSTDS750");
		this.RSTDS750_Event.addEventListener("mousedown", this.RSTDS750_Press.bind(this));
		this.RSPMS750_Event = this.getChildById("RSPMS750");
		this.RSPMS750_Event.addEventListener("mousedown", this.RSPMS750_Press.bind(this));
		this.RSKLN90B_Event = this.getChildById("RSKLN90B");
		this.RSKLN90B_Event.addEventListener("mousedown", this.RSKLN90B_Press.bind(this));
		this.RSG430_Event = this.getChildById("RSG430");
		this.RSG430_Event.addEventListener("mousedown", this.RSG430_Press.bind(this));
		this.VARIOUSSTUFF_Event = this.getChildById("VARIOUSSTUFF");
		this.VARIOUSSTUFF_Event.addEventListener("mousedown", this.VARIOUSSTUFF_Press.bind(this));
		this.CARGO_BAGS_Event = this.getChildById("CARGO_BAGS");
		this.CARGO_BAGS_Event.addEventListener("mousedown", this.CARGO_BAGS_Press.bind(this));
		this.CARGO_LUGGAGE_Event = this.getChildById("CARGO_LUGGAGE");
		this.CARGO_LUGGAGE_Event.addEventListener("mousedown", this.CARGO_LUGGAGE_Press.bind(this));
		this.CARGO_L_EMPTY_Event = this.getChildById("CARGO_L_EMPTY");
		this.CARGO_L_EMPTY_Event.addEventListener("mousedown", this.CARGO_L_EMPTY_Press.bind(this));
		this.CARGO_R_EMPTY_Event = this.getChildById("CARGO_R_EMPTY");
		this.CARGO_R_EMPTY_Event.addEventListener("mousedown", this.CARGO_R_EMPTY_Press.bind(this));
		this.CARGO_L_CAMPING_Event = this.getChildById("CARGO_L_CAMPING");
		this.CARGO_L_CAMPING_Event.addEventListener("mousedown", this.CARGO_LR_CAMPING_Press.bind(this));
		this.CARGO_R_CAMPING_Event = this.getChildById("CARGO_R_CAMPING");
		this.CARGO_R_CAMPING_Event.addEventListener("mousedown", this.CARGO_LR_CAMPING_Press.bind(this));
		this.CARGO_L_CRATES_Event = this.getChildById("CARGO_L_CRATES");
		this.CARGO_L_CRATES_Event.addEventListener("mousedown", this.CARGO_L_CRATES_Press.bind(this));
		this.CARGO_R_CRATES_Event = this.getChildById("CARGO_R_CRATES");
		this.CARGO_R_CRATES_Event.addEventListener("mousedown", this.CARGO_R_CRATES_Press.bind(this));
		this.CARGO_L_CBBOXES_Event = this.getChildById("CARGO_L_CBBOXES");
		this.CARGO_L_CBBOXES_Event.addEventListener("mousedown", this.CARGO_L_CBBOXES_Press.bind(this));
		this.CARGO_R_CBBOXES_Event = this.getChildById("CARGO_R_CBBOXES");
		this.CARGO_R_CBBOXES_Event.addEventListener("mousedown", this.CARGO_R_CBBOXES_Press.bind(this));
		this.CARGO_L_TANKS_Event = this.getChildById("CARGO_L_TANKS");
		this.CARGO_L_TANKS_Event.addEventListener("mousedown", this.CARGO_L_TANKS_Press.bind(this));
		this.CARGO_R_TANKS_Event = this.getChildById("CARGO_R_TANKS");
		this.CARGO_R_TANKS_Event.addEventListener("mousedown", this.CARGO_R_TANKS_Press.bind(this));
		this.CARGO_L_FCASES_Event = this.getChildById("CARGO_L_FCASES");
		this.CARGO_L_FCASES_Event.addEventListener("mousedown", this.CARGO_L_FCASES_Press.bind(this));
		this.CARGO_R_FCASES_Event = this.getChildById("CARGO_R_FCASES");
		this.CARGO_R_FCASES_Event.addEventListener("mousedown", this.CARGO_R_FCASES_Press.bind(this));

		this.UNLOAD_Event = this.getChildById("UNLOAD");
		this.UNLOAD_Event.addEventListener("mousedown", this.UNLOAD_Press.bind(this));

		this.COLDDARK_Event = this.getChildById("COLDDARK");
		this.COLDDARK_Event.addEventListener("mousedown", this.COLDDARK_Press.bind(this));
		this.COLDDARK_Event.addEventListener("mouseup", this.COLDDARK_Release.bind(this));
		this.COLDDARK_Event = 0;

		this.SAVENOW_Event = this.getChildById("SAVENOW");
		this.SAVENOW_Event.addEventListener("mousedown", this.SAVENOW_Press.bind(this));
		this.SAVENOW_Event.addEventListener("mouseup", this.SAVENOW_Release.bind(this));
		this.SAVENOW_Button_State = 0;

		// Debug buttons
		this.LOADNOW_Event = this.getChildById("LOADNOW");
		this.LOADNOW_Event.addEventListener("mousedown", this.LOADNOW_Press.bind(this));
		this.SAVE2_Event = this.getChildById("SAVE2");
		this.SAVE2_Event.addEventListener("mousedown", this.SAVE2_Press.bind(this));
		this.LOAD2_Event = this.getChildById("LOAD2");
		this.LOAD2_Event.addEventListener("mousedown", this.LOAD2_Press.bind(this));
		this.MISC1_Event = this.getChildById("MISC1");
		this.MISC1_Event.addEventListener("mousedown", this.MISC1_Press.bind(this));
		this.MISC2_Event = this.getChildById("MISC2");
		this.MISC2_Event.addEventListener("mousedown", this.MISC2_Press.bind(this));
		this.MISC3_Event = this.getChildById("MISC3");
		this.MISC3_Event.addEventListener("mousedown", this.MISC3_Press.bind(this));

		this.ROOFWINDOWS_Event = this.getChildById("ROOFWINDOWS");
		this.ROOFWINDOWS_Event.addEventListener("mousedown", this.ROOFWINDOWS_Press.bind(this));
	}
	disconnectedCallback() {
		super.disconnectedCallback();
	}
	Init() {
		super.Init();
	}
	onInteractionEvent(_args) {
	}
	onFlightStart() {
		this.STATE_SAVING_onflight_start = 1;
		this.STATE_SAVING_load_delay = this.STATE_SAVING_default_load_delay;
		/* Load book configuration */
		this.LOAD_configuration();
		/* and state */
		this.STATE_SAVING_load();
	}
	/**********************/
	/* Check last version */
	/**********************/
	checkLastVersion() {
		var url = "https://www.bagolu.com/api/bagolu-c172-m.json";
		let httpRequest = new XMLHttpRequest();
		httpRequest.open("GET", url, true);
		httpRequest.setRequestHeader('Accept', 'application/json, text/javascript, text/plain');
		httpRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		httpRequest.onerror = evt => {
			SimVar.SetSimVarValue("L:BAGOLUC172_POSTIT", "bool", 0);
			return false;
		};
		httpRequest.ontimeout = evt => {
			SimVar.SetSimVarValue("L:BAGOLUC172_POSTIT", "bool", 0);
			return false;
		};
		httpRequest.onload = evt => {
			if (httpRequest.status >= 200 && httpRequest.status < 300) {
				let tmpjson = JSON.parse(httpRequest.response);
				if (tmpjson.last_release == this.current_version)
					SimVar.SetSimVarValue("L:BAGOLUC172_POSTIT", "bool", 0);
				else
					SimVar.SetSimVarValue("L:BAGOLUC172_POSTIT", "bool", 1);
				return true;
			} else {
				SimVar.SetSimVarValue("L:BAGOLUC172_POSTIT", "bool", 0);
				return false;
			}
		};
		httpRequest.send();
	}
	/******************/
	/* String to hash */
	/******************/
	hashCode (str) {
		var hash = 0, i = 0, len = str.length;
		while ( i < len ) {
		hash  = ((hash << 5) - hash + str.charCodeAt(i++)) << 0;
		}
		return hash;
	}
	/**************************/
	/* Read vars from storage */
	/**************************/
	read(key, def) {
		var key2 = this.STATE_SAVING_prefix + key;
		var ret = GetStoredData(key2);
		if ( (typeof(ret) == 'string') && (ret == "") || (typeof(ret) == 'undefined' )) {
			return def;
		} else {
			return ret;
		}
	}
	/*************************/
	/* Write vars to storage */
	/*************************/
	write(key, v) {
		var key2 = this.STATE_SAVING_prefix + key;
		if (v == true || v == "true" || v == 1) { v = "1"; }
		if (v == false || v == "false" || v == 0) { v = "0"; }
		SetStoredData(key2, v.toString());
	}
	/*******************/
	/* Update received */
	/*******************/
	Update() {
		super.Update();
		//STATE SAVING
		if (this.STATE_SAVING_onflight_start && this.STATE_SAVING_on_off) {
			if (this.STATE_SAVING_save_delay > 0) {
				this.STATE_SAVING_save_delay = this.STATE_SAVING_save_delay - 1;
			} else if (this.STATE_SAVING_save_delay == 0) {
				// Save loop
				this.STATE_SAVING_save();
				this.STATE_SAVING_save_delay = this.STATE_SAVING_default_save_delay;
			}
			//if (this.STATE_SAVING_load_delay > 0) {
			//	this.STATE_SAVING_load_delay = this.STATE_SAVING_load_delay - 1;
			//} else if (this.STATE_SAVING_load_delay == 0) {
			//	// Loading delay
			//	this.STATE_SAVING_load();
			//	this.STATE_SAVING_load_delay = -1;
			//	this.STATE_SAVING_save_delay = this.STATE_SAVING_default_save_delay;
			//}
		}
		//Race condition on GPS units loading, need to insist
		// (not proud of this, but no other way in async mode)
		if (this.radiostackloop>0) {
			this.RadioStackSetting();
			this.radiostackloop--;
		}
		if (this.kap140wait) {
			this.RadioStackSettingKAP140();
		}
		//BOOK PAGES
		if (this.page == 0) {
			this.BOOK_PAGE0.style.visibility = "visible";
			this.BOOK_PAGE1.style.visibility = "hidden";
			this.BOOK_PAGE2.style.visibility = "hidden";
			this.BOOK_PAGE9.style.visibility = "hidden";
		}
		if (this.page == 1) {
			this.BOOK_PAGE0.style.visibility = "hidden";
			this.BOOK_PAGE1.style.visibility = "visible";
			this.BOOK_PAGE2.style.visibility = "hidden";
			this.BOOK_PAGE9.style.visibility = "hidden";
		}
		if (this.page == 2) {
			this.BOOK_PAGE0.style.visibility = "hidden";
			this.BOOK_PAGE1.style.visibility = "hidden";
			this.BOOK_PAGE2.style.visibility = "visible";
			this.BOOK_PAGE9.style.visibility = "hidden";
		}
		if (this.page == 9) {
			this.BOOK_PAGE0.style.visibility = "hidden";
			this.BOOK_PAGE1.style.visibility = "hidden";
			this.BOOK_PAGE2.style.visibility = "hidden";
			this.BOOK_PAGE9.style.visibility = "visible";
		}

		//BUTTONS DRAWINGS

		this.STATE_SAVING_Event.style.background	= (this.STATE_SAVING_on_off) ? "#666" : "#eee";
		this.HIDE_MANUAL_LOGO_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_HIDE_MANUAL_LOGO", "Bool")) ? "#666" : "#eee";
		this.PILOTVISIBLE_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_PILOT_VISIBLE", "Bool")) ? "#666" : "#eee";
		this.COPILOTVISIBLE_Event.style.background 	= (SimVar.GetSimVarValue("L:BAGOLUC172_COPILOT_VISIBLE", "Bool")) ? "#666" : "#eee";
		this.LEFTPASSENGER_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_LEFTPASSENGER", "Bool")) ? "#666" : "#eee";
		this.RIGHTPASSENGER_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_RIGHTPASSENGER", "Bool")) ? "#666" : "#eee";
		this.BACKSEATS_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_BACK_SEATS", "Bool")) ? "#666" : "#eee";
		this.FRONTRIGHTSEAT_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_FRONT_RIGHT_SEAT", "Bool")) ? "#666" : "#eee";
		this.FRONTFAIRINGS_Event.style.background       = (SimVar.GetSimVarValue("L:BAGOLUC172_FAIRINGS_FRONT", "Bool")) ? "#666" : "#eee";
		this.BACKFAIRINGS_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_FAIRINGS_BACK", "Bool")) ? "#666" : "#eee";
		this.BUTTONSLIST_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_BUTTONSLIST", "Bool")) ? "#666" : "#eee";
		this.CARDLIST_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_CARDLIST", "Bool")) ? "#666" : "#eee";
		this.WHEELCHOCKS_Event.style.background 	= (SimVar.GetSimVarValue("L:BAGOLUC172_WHEELCHOCKS", "Bool")) ? "#666" : "#eee";
		this.GPU_Event.style.background		 	= (SimVar.GetSimVarValue("L:BAGOLUC172_GPU_VISIBLE", "Bool")) ? "#666" : "#eee";
		this.TIEDOWNS_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_TIEDOWNS", "Bool")) ? "#666" : "#eee";
		this.COVERS_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_COVERS", "Bool")) ? "#666" : "#eee";
		this.VARIOUSSTUFF_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_VARIOUSSTUFF", "Bool")) ? "#666" : "#eee";
		this.COMPASS0_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_COMPASS1", "Bool") == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_COMPASS2", "Bool") == 0 ) ? "#666" : "#eee";
		this.COMPASS1_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_COMPASS1", "Bool")) ? "#666" : "#eee";
		this.COMPASS2_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_COMPASS2", "Bool")) ? "#666" : "#eee";
		this.FDGYRO_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_FDGYRO", "Bool")) ? "#666" : "#eee";
		this.FDHSI_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_FDHSI", "Bool")) ? "#666" : "#eee";
		this.FDG5_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_FDG5", "Bool")) ? "#666" : "#eee";
		this.HZSTD_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_HZSTD", "Bool")) ? "#666" : "#eee";
		this.HZG5_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_HZG5", "Bool")) ? "#666" : "#eee";
		this.AOA_Event.style.background			= (SimVar.GetSimVarValue("L:BAGOLUC172_AOA_VISIBLE", "Bool")) ? "#666" : "#eee";
		this.RSVFR_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_RADIOSTACK", "number")==0) ? "#666" : "#eee";
		this.RSRADIOS_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_RADIOSTACK", "number")==1) ? "#666" : "#eee";
		this.RSKLN90B_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_RADIOSTACK", "number")==2) ? "#666" : "#eee";
		this.RSG430_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_RADIOSTACK", "number")==3) ? "#666" : "#eee";
		this.RSTDS750_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_RADIOSTACK", "number")==4) ? "#666" : "#eee";
		this.RSPMS750_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_RADIOSTACK", "number")==5) ? "#666" : "#eee";

		this.CARGO_BAGS_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_BAGS", "Bool")) ? "#666" : "#eee";
		this.CARGO_LUGGAGE_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LUGGAGE", "Bool")) ? "#666" : "#eee";
		this.CARGO_L_EMPTY_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool")) ? "#666" : "#eee";
		this.CARGO_R_EMPTY_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool")) ? "#666" : "#eee";
		this.CARGO_L_CAMPING_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool")) ? "#666" : "#eee";
		this.CARGO_R_CAMPING_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool")) ? "#666" : "#eee";
		this.CARGO_L_CRATES_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES", "Bool")) ? "#666" : "#eee";
		this.CARGO_R_CRATES_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES", "Bool")) ? "#666" : "#eee";
		this.CARGO_L_CBBOXES_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES", "Bool")) ? "#666" : "#eee";
		this.CARGO_R_CBBOXES_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES", "Bool")) ? "#666" : "#eee";
		this.CARGO_L_TANKS_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS", "Bool")) ? "#666" : "#eee";
		this.CARGO_R_TANKS_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS", "Bool")) ? "#666" : "#eee";
		this.CARGO_L_FCASES_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES", "Bool")) ? "#666" : "#eee";
		this.CARGO_R_FCASES_Event.style.background	= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES", "Bool")) ? "#666" : "#eee";

		this.UNLOAD_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_UNLOAD", "Bool")) ? "#666" : "#eee";

		this.SAVENOW_Event.style.background		= (this.SAVENOW_Button_State ==1) ? "#666" : "#aaa";

		this.ROOFWINDOWS_Event.style.background		= (SimVar.GetSimVarValue("L:BAGOLUC172_ROOFWINDOWS", "Bool")) ? "#666" : "#eee";

		this.getChildById("planefaceff").style.visibility = (this.page == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_FAIRINGS_FRONT", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("planefacefb").style.visibility = (this.page == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_FAIRINGS_BACK", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("planefacetd").style.visibility = (this.page == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_TIEDOWNS", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("planefacewc").style.visibility = (this.page == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_WHEELCHOCKS", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("planefacecv").style.visibility = (this.page == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_COVERS", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("planefacegp").style.visibility = (this.page == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_GPU_VISIBLE", "Bool") == 1) ? "visible" : "hidden";

		this.getChildById("panelfacecc").style.visibility  = (this.page == 1 && SimVar.GetSimVarValue("L:BAGOLUC172_CARDLIST", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("panelfacecb").style.visibility  = (this.page == 1 && SimVar.GetSimVarValue("L:BAGOLUC172_BUTTONSLIST", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("panelfacehl").style.visibility  = (this.page == 1 && SimVar.GetSimVarValue("L:BAGOLUC172_HIDE_MANUAL_LOGO", "Bool") == 0) ? "visible" : "hidden";
		this.getChildById("panelfacec1").style.visibility  = (this.page == 1 && SimVar.GetSimVarValue("L:BAGOLUC172_COMPASS1", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("panelfacec2").style.visibility  = (this.page == 1 && SimVar.GetSimVarValue("L:BAGOLUC172_COMPASS2", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("panelfaceaoa").style.visibility = (this.page == 1 && SimVar.GetSimVarValue("L:BAGOLUC172_AOA_VISIBLE", "Bool") == 1) ? "visible" : "hidden";

		var backseats = (SimVar.GetSimVarValue("L:BAGOLUC172_BACK_SEATS", "Bool") == 1);
		var empty = (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool") == 1) && (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool") == 1);
		this.getChildById("cargofacebags").style.visibility      = (this.page == 2 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_BAGS", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacebackseats").style.visibility = (this.page == 2 && SimVar.GetSimVarValue("L:BAGOLUC172_BACK_SEATS", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacefrontseat").style.visibility = (this.page == 2 && SimVar.GetSimVarValue("L:BAGOLUC172_FRONT_RIGHT_SEAT", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofaceluggage").style.visibility   = (this.page == 2 && (empty == 1 || backseats ==1) && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LUGGAGE", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacepaxL").style.visibility      = (this.page == 2 && backseats == 1 && SimVar.GetSimVarValue("L:BAGOLUC172_LEFTPASSENGER", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacepaxR").style.visibility      = (this.page == 2 && backseats == 1 && SimVar.GetSimVarValue("L:BAGOLUC172_RIGHTPASSENGER", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofaceboxesL").style.visibility    = (this.page == 2 && backseats == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofaceboxesR").style.visibility    = (this.page == 2 && backseats == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacecamping").style.visibility   = (this.page == 2 && backseats == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacecasesL").style.visibility    = (this.page == 2 && backseats == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacecasesR").style.visibility    = (this.page == 2 && backseats == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacecratesL").style.visibility   = (this.page == 2 && backseats == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacecratesR").style.visibility   = (this.page == 2 && backseats == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacetanksL").style.visibility    = (this.page == 2 && backseats == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS", "Bool") == 1) ? "visible" : "hidden";
		this.getChildById("cargofacetanksR").style.visibility    = (this.page == 2 && backseats == 0 && SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS", "Bool") == 1) ? "visible" : "hidden";
	}
	/********************/
	/* Save all options */
	/********************/
	SAVENOW_Press() {
		this.SAVE_configuration();
	}
	SAVENOW_Release() {
		this.SAVENOW_Button_State = 0;
	}
	SAVE_configuration() {
		this.SAVENOW_Button_State = 1;
		this.write('STATE_SAVING', 	SimVar.GetSimVarValue("L:BAGOLUC172_STATE_SAVING", 	"Bool") == 1);
		this.write('HIDE_MANUAL_LOGO', 	SimVar.GetSimVarValue("L:BAGOLUC172_HIDE_MANUAL_LOGO", 	"Bool") == 1);
		this.write('BACK_SEATS', 	SimVar.GetSimVarValue("L:BAGOLUC172_BACK_SEATS", 	"Bool") == 1);
		this.write('FRONT_RIGHT_SEAT', 	SimVar.GetSimVarValue("L:BAGOLUC172_FRONT_RIGHT_SEAT", 	"Bool") == 1);
		this.write('PILOT_VISIBLE', 	SimVar.GetSimVarValue("L:BAGOLUC172_PILOT_VISIBLE", 	"Bool") == 1);
		this.write('COPILOT_VISIBLE',	SimVar.GetSimVarValue("L:BAGOLUC172_COPILOT_VISIBLE", 	"Bool") == 1);
		this.write('LEFTPASSENGER',	SimVar.GetSimVarValue("L:BAGOLUC172_LEFTPASSENGER", 	"Bool") == 1);
		this.write('RIGHTPASSENGER',	SimVar.GetSimVarValue("L:BAGOLUC172_RIGHTPASSENGER", 	"Bool") == 1);
		this.write('FAIRINGS_FRONT',    SimVar.GetSimVarValue("L:BAGOLUC172_FAIRINGS_FRONT",    "Bool") == 1);
		this.write('FAIRINGS_BACK',     SimVar.GetSimVarValue("L:BAGOLUC172_FAIRINGS_BACK",     "Bool") == 1);
		this.write('BUTTONSLIST',	SimVar.GetSimVarValue("L:BAGOLUC172_BUTTONSLIST", 	"Bool") == 1);
		this.write('CARDLIST',		SimVar.GetSimVarValue("L:BAGOLUC172_CARDLIST", 		"Bool") == 1);
		this.write('WHEELCHOCKS',	SimVar.GetSimVarValue("L:BAGOLUC172_WHEELCHOCKS", 	"Bool") == 1);
		this.write('GPU',		SimVar.GetSimVarValue("L:BAGOLUC172_GPU_VISIBLE", 	"Bool") == 1);
		this.write('TIEDOWNS',		SimVar.GetSimVarValue("L:BAGOLUC172_TIEDOWNS", 		"Bool") == 1);
		this.write('COVERS',		SimVar.GetSimVarValue("L:BAGOLUC172_COVERS", 		"Bool") == 1);
		this.write('VARIOUSSTUFF',	SimVar.GetSimVarValue("L:BAGOLUC172_VARIOUSSTUFF", 	"Bool") == 1);
		this.write('COMPASS1',		SimVar.GetSimVarValue("L:BAGOLUC172_COMPASS1", 		"Bool") == 1);
		this.write('COMPASS2',		SimVar.GetSimVarValue("L:BAGOLUC172_COMPASS2", 		"Bool") == 1);
		this.write('FDGYRO',		SimVar.GetSimVarValue("L:BAGOLUC172_FDGYRO", 		"Bool") == 1);
		this.write('FDHSI',		SimVar.GetSimVarValue("L:BAGOLUC172_FDHSI", 		"Bool") == 1);
		this.write('FDG5',		SimVar.GetSimVarValue("L:BAGOLUC172_FDG5", 		"Bool") == 1);
		this.write('HZSTD',		SimVar.GetSimVarValue("L:BAGOLUC172_HZSTD", 		"Bool") == 1);
		this.write('HZG5',		SimVar.GetSimVarValue("L:BAGOLUC172_HZG5", 		"Bool") == 1);
		this.write('AOAVISIBLE',	SimVar.GetSimVarValue("L:BAGOLUC172_AOA_VISIBLE",	"Bool") == 1);
		this.write('AOAENABLE',		SimVar.GetSimVarValue("L:BAGOLUC172_AOA_ENABLE",	"Bool") == 1);
		this.write('CARGO_BAGS',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_BAGS", 	"Bool") == 1);
		this.write('CARGO_LUGGAGE',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LUGGAGE", 	"Bool") == 1);
		this.write('CARGO_L_EMPTY',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", 	"Bool") == 1);
		this.write('CARGO_R_EMPTY',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", 	"Bool") == 1);
		this.write('CARGO_LR_CAMPING',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1);
		this.write('CARGO_L_CRATES',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES", 	"Bool") == 1);
		this.write('CARGO_R_CRATES',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES", 	"Bool") == 1);
		this.write('CARGO_L_CBBOXES',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES", 	"Bool") == 1);
		this.write('CARGO_R_CBBOXES',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES", 	"Bool") == 1);
		this.write('CARGO_L_TANKS',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS", 	"Bool") == 1);
		this.write('CARGO_R_TANKS',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS", 	"Bool") == 1);
		this.write('CARGO_L_FCASES',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES", 	"Bool") == 1);
		this.write('CARGO_R_FCASES',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES", 	"Bool") == 1);
		this.write('CARGO_UNLOAD',	SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_UNLOAD", 	"Bool") == 1);

		this.write('ROOFWINDOWS',       SimVar.GetSimVarValue("L:BAGOLUC172_ROOFWINDOWS",       "Bool") == 1);

		// Radiostack
		this.write('RADIOSTACK',	SimVar.GetSimVarValue("L:BAGOLUC172_RADIOSTACK", 	"number"));
	}
	/********************/
	/* Read all options */
	/********************/
	LOADNOW_Press(){
		this.LOAD_configuration();
	}
	LOAD_configuration() {
		this.STATE_SAVING_on_off = (this.read("STATE_SAVING", 0) == "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_STATE_SAVING", 	"bool", this.STATE_SAVING_on_off);
		SimVar.SetSimVarValue("L:BAGOLUC172_HIDE_MANUAL_LOGO", 	"bool", this.read("HIDE_MANUAL_LOGO", 0) 	== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_BACK_SEATS", 	"bool", this.read("BACK_SEATS", 1) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_FRONT_RIGHT_SEAT", 	"bool", this.read("FRONT_RIGHT_SEAT", 1) 	== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_PILOT_VISIBLE", 	"bool", this.read("PILOT_VISIBLE", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_COPILOT_VISIBLE", 	"bool", this.read("COPILOT_VISIBLE", 0) 	== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_LEFTPASSENGER", 	"bool", this.read("LEFTPASSENGER", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_RIGHTPASSENGER", 	"bool", this.read("RIGHTPASSENGER", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_FAIRINGS_FRONT",    "bool", this.read("FAIRINGS_FRONT", 1)	  == "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_FAIRINGS_BACK",     "bool", this.read("FAIRINGS_BACK", 1)	   == "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_BUTTONSLIST", 	"bool", this.read("BUTTONSLIST", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARDLIST", 		"bool", this.read("CARDLIST", 1) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_WHEELCHOCKS", 	"bool", this.read("WHEELCHOCKS", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_GPU_VISIBLE", 	"bool", this.read("GPU", 0) 			== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_TIEDOWNS", 		"bool", this.read("TIEDOWNS", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_COVERS", 		"bool", this.read("COVERS", 0) 			== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_VARIOUSSTUFF", 	"bool", this.read("VARIOUSSTUFF", 1) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_COMPASS1", 		"bool", this.read("COMPASS1", 1) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_COMPASS2", 		"bool", this.read("COMPASS2", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_AOA_VISIBLE", 	"bool", this.read("AOAVISIBLE", 1) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_AOA_ENABLE", 	"bool", this.read("AOAENABLE", 1) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_BAGS",	"Bool", this.read("CARGO_BAGS", 1) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LUGGAGE",	"Bool", this.read("CARGO_LUGGAGE", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY",	"Bool", this.read("CARGO_L_EMPTY", 1) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY",	"Bool", this.read("CARGO_R_EMPTY", 1) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING",	"Bool", this.read("CARGO_LR_CAMPING", 0) 	== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES",	"Bool", this.read("CARGO_L_CRATES", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES",	"Bool", this.read("CARGO_R_CRATES", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES",	"Bool", this.read("CARGO_L_CBBOXES", 0) 	== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES",	"Bool", this.read("CARGO_R_CBBOXES", 0) 	== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS",	"Bool", this.read("CARGO_L_TANKS", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS",	"Bool", this.read("CARGO_R_TANKS", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES",	"Bool", this.read("CARGO_L_FCASES", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES",	"Bool", this.read("CARGO_R_FCASES", 0) 		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARDBOARD",		"Bool", this.read("CARDBOARD", 0)		== "1");
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_UNLOAD",	"Bool", this.read("CARGO_UNLOAD", 0)		== "1");

		SimVar.SetSimVarValue("L:BAGOLUC172_ROOFWINDOWS",       "bool", this.read("ROOFWINDOWS", 0)	     == "1");

		// Radiostack init after load
		this.radiostack = Number(this.read("RADIOSTACK", 1));
		this.RadioStackSetting();

		// HSI
		var fd1 = (this.read("FDGYRO", 1) == "1");
		var fd2 = (this.read("FDHSI", 0) == "1");
		var fd3 = (this.read("FDG5", 0) == "1");
		if (!fd1 && !fd2 && !fd3) { fd1 = true; }
		SimVar.SetSimVarValue("L:BAGOLUC172_FDGYRO",	"bool", fd1);
		SimVar.SetSimVarValue("L:BAGOLUC172_FDHSI",	"bool", fd2);
		SimVar.SetSimVarValue("L:BAGOLUC172_FDG5",	"bool", fd3);
		// HZ
		var hz1 = (this.read("HZSTD", 1) == "1");
		var hz2 = (this.read("HZG5", 0) == "1");
		if (!hz1 && !hz2) { hz1 = true; }
		SimVar.SetSimVarValue("L:BAGOLUC172_HZSTD",	"bool", hz1);
		SimVar.SetSimVarValue("L:BAGOLUC172_HZG5",	"bool", hz2);
	}
	/***************/
	/* Cold & dark */
	/***************/
	COLDDARK_Press() {
		this.COLDDARK_Button_State = 1;
		// Only on parking spot
		if (SimVar.GetSimVarValue("SIM ON GROUND", "number") == 1) {
			//
			SimVar.SetSimVarValue("K:ALTERNATOR_SET",		"bool",		0);
			SimVar.SetSimVarValue("ELECTRICAL MASTER BATTERY:1",	"bool",		0);
			SimVar.SetSimVarValue("ELECTRICAL MASTER BATTERY:2",	"bool",		0);
			SimVar.SetSimVarValue("K:AVIONICS_MASTER_1_SET",	"bool",		0);
			SimVar.SetSimVarValue("K:AVIONICS_MASTER_2_SET",	"bool",		0);

			SimVar.SetSimVarValue("A:LIGHT BEACON", 		"bool", 	0);
			SimVar.SetSimVarValue("A:LIGHT LANDING", 		"bool",		0);
			SimVar.SetSimVarValue("A:LIGHT TAXI", 			"bool",		0);
			SimVar.SetSimVarValue("A:LIGHT NAV", 			"bool",		0);
			SimVar.SetSimVarValue("A:LIGHT STROBE", 		"bool", 	0);

			SimVar.SetSimVarValue("L:BAGOLUC172_CABIN1", 		"percent", 	0);
			SimVar.SetSimVarValue("L:BAGOLUC172_CABIN2", 		"percent", 	0);
			SimVar.SetSimVarValue("L:BAGOLUC172_LIGHTPANEL1", 	"percent", 	0);
			SimVar.SetSimVarValue("L:BAGOLUC172_LIGHTPANEL2", 	"percent", 	0);
			SimVar.SetSimVarValue("L:BAGOLUC172_LIGHTPANEL3", 	"percent", 	0);

			SimVar.SetSimVarValue("K:ELECT_FUEL_PUMP1_SET", 	"bool",		0);
			SimVar.SetSimVarValue("K:PITOT_HEAT_SET", 		"bool",		0);

			SimVar.SetSimVarValue("K:PARKING_BRAKE_SET", 		"bool",		1);
			//SimVar.SetSimVarValue("K:SET_FUEL_VALVE_ENG1",		"bool",		0);
			SimVar.SetSimVarValue("K:FUEL_SELECTOR_SET", 		"number",	0);

			if (SimVar.GetSimVarValue("A:ALTERNATE STATIC SOURCE OPEN", "Bool")==1) {
				SimVar.SetSimVarValue("K:TOGGLE_ALTERNATE_STATIC", "bool", 1);
			}
			SimVar.SetSimVarValue("A:FLAPS HANDLE INDEX",		"number",		0);
			SimVar.SetSimVarValue("K:AXIS_ELEV_TRIM_SET",		"POSITION 16k",	0);
			SimVar.SetSimVarValue("K:KOHLSMAN_SET",			"Millibars",	1013.2*16);

			SimVar.SetSimVarValue("A:GENERAL ENG THROTTLE LEVER POSITION:1", "percent",	0);
			SimVar.SetSimVarValue("A:GENERAL ENG MIXTURE LEVER POSITION:1",  "percent",	0);

			SimVar.SetSimVarValue("FUEL TANK LEFT MAIN QUANTITY",  	"gallons",	14);
			SimVar.SetSimVarValue("FUEL TANK RIGHT MAIN QUANTITY", 	"gallons",	14);

			SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left1",	"number", 0);
			SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left2",	"number", 0);
			SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left3",	"number", 0);
			SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left4",	"number", 0);
			SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right1",	"number", 0);
			SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right2",	"number", 0);
			SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right3",	"number", 0);
			SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right4",	"number", 0);
			SimVar.SetSimVarValue("L:XML_bagoluC172_Door_left",		"number", 0);
			SimVar.SetSimVarValue("L:XML_bagoluC172_Door_right",		"number", 0);
			SimVar.SetSimVarValue("L:XML_bagoluC172_Window_left",		"number", 0);
			SimVar.SetSimVarValue("L:XML_bagoluC172_Window_right",		"number", 0);

			SimVar.SetSimVarValue("L:BAGOLUC172_WHEELCHOCKS", 		"bool",   1);
			SimVar.SetSimVarValue("L:BAGOLUC172_GPU_VISIBLE", 		"bool",   0);
			SimVar.SetSimVarValue("L:BAGOLUC172_TIEDOWNS", 			"bool",   1);
			SimVar.SetSimVarValue("L:BAGOLUC172_COVERS", 			"bool",   1);

			SimVar.SetSimVarValue("L:BAGOLUC172_CARDBOARD",			"bool",   0);
		}
	}
	COLDDARK_Release() {
		this.COLDDARK_Button_State = 0;
	}
	/***************************/
	/* State Saving options box*/
	/***************************/
	STATE_SAVING_Press() {
		if(SimVar.GetSimVarValue("L:BAGOLUC172_STATE_SAVING", "Bool") == 0) {
			SimVar.SetSimVarValue("L:BAGOLUC172_STATE_SAVING", "Bool", 1);
			this.write('STATE_SAVING', "1");
			this.STATE_SAVING_on_off = 1;
			this.STATE_SAVING_save_delay = this.STATE_SAVING_default_save_delay;
			this.STATE_SAVING_onflight_start = 1; /* it seems to ==0 sometimes... resetting state saving will save then */
		} else {
			SimVar.SetSimVarValue("L:BAGOLUC172_STATE_SAVING", "Bool", 0);
			this.write('STATE_SAVING', "0");
			this.STATE_SAVING_on_off = 0;
			this.STATE_SAVING_save_delay = -1;
		}
	}
	// state saving debug load button
	LOAD2_Press() {
		this.STATE_SAVING_load();
	}
	// state saving debug save button
	SAVE2_Press() {
		this.STATE_SAVING_save();
	}
	// Misc debug
	MISC1_Press() {
	    var t="L:XMLVAR_GPS_DISABLED_AS530_1";
	    SimVar.SetSimVarValue(t, "Bool", (SimVar.GetSimVarValue(t, "Bool") == 0));
	    var t="L:XMLVAR_GPS_DISABLED_AS430_1";
	    SimVar.SetSimVarValue(t, "Bool", (SimVar.GetSimVarValue(t, "Bool") == 0));
	    var t="L:TDSGTNXI_InactiveVar";
	    SimVar.SetSimVarValue(t, "Bool", (SimVar.GetSimVarValue(t, "Bool") == 0));
	}
	MISC2_Press() {
	    SimVar.SetSimVarValue("L:TDSGTNXI750U1_ElectricalCircuit", "Bool", 0);
	    SimVar.SetSimVarValue("L:TDSGTNXI650U2_ElectricalCircuit", "Bool", 0);
	}
	MISC3_Press() {
	    SimVar.SetSimVarValue("L:TDSGTNXI750U1_ElectricalCircuit", "Bool", 99);
	    SimVar.SetSimVarValue("L:TDSGTNXI650U2_ElectricalCircuit", "Bool", 99);
	}

	/*********************/
	/* Save cockpit vars */
	/*********************/
	STATE_SAVING_save() {
		this.write('MASTER_ALTERNATOR', 	SimVar.GetSimVarValue("GENERAL ENG MASTER ALTERNATOR:1",	"Bool").toString());
		this.write('MASTER_BATTERY',		SimVar.GetSimVarValue("ELECTRICAL MASTER BATTERY:1", 		"Bool").toString());
		this.write('BACKUP_BATTERY',		SimVar.GetSimVarValue("ELECTRICAL MASTER BATTERY:2", 		"Bool").toString());
		this.write('AVIONICS_MASTER_1',		SimVar.GetSimVarValue("A:CIRCUIT SWITCH ON:24", 		"Bool").toString());
		this.write('AVIONICS_MASTER_2',		SimVar.GetSimVarValue("A:CIRCUIT SWITCH ON:25", 		"Bool").toString());

		this.write('LIGHT_BEACON', 		SimVar.GetSimVarValue("A:LIGHT BEACON", 			"Bool").toString());
		this.write('LIGHT_LANDING', 		SimVar.GetSimVarValue("A:LIGHT LANDING", 			"Bool").toString());
		this.write('LIGHT_TAXI', 		SimVar.GetSimVarValue("A:LIGHT TAXI", 				"Bool").toString());
		this.write('LIGHT_NAV', 		SimVar.GetSimVarValue("A:LIGHT NAV", 				"Bool").toString());
		this.write('LIGHT_STROBE', 		SimVar.GetSimVarValue("A:LIGHT STROBE", 			"Bool").toString());

		this.write('LIGHT_CABIN1',		SimVar.GetSimVarValue("L:BAGOLUC172_CABIN1",			"number").toString());
		this.write('LIGHT_CABIN2',		SimVar.GetSimVarValue("L:BAGOLUC172_CABIN2",			"number").toString());
		this.write('LIGHT_PANEL1',		SimVar.GetSimVarValue("L:BAGOLUC172_LIGHTPANEL1",		"number").toString());
		this.write('LIGHT_PANEL2',		SimVar.GetSimVarValue("L:BAGOLUC172_LIGHTPANEL2",		"number").toString());
		this.write('LIGHT_PANEL3',		SimVar.GetSimVarValue("L:BAGOLUC172_LIGHTPANEL3",		"number").toString());

		this.write('FUEL_PUMP',			SimVar.GetSimVarValue("GENERAL ENG FUEL PUMP SWITCH:1", 	"Bool").toString());
		this.write('PITOT_HEAT',		SimVar.GetSimVarValue("PITOT HEAT SWITCH", 			"Bool").toString());

		this.write('YokeHidden1', 		SimVar.GetSimVarValue("L:XMLVAR_YokeHidden1",			"Bool").toString());
		this.write('YokeHidden2', 		SimVar.GetSimVarValue("L:XMLVAR_YokeHidden2",			"Bool").toString());

		this.write('PARKING_BREAK', 		SimVar.GetSimVarValue("A:BRAKE PARKING POSITION",		"Bool").toString());
		//this.write('FUEL_VALVE', 		SimVar.GetSimVarValue("A:GENERAL ENG FUEL VALVE:1",		"Bool").toString());
		this.write('FUEL_SELECTOR', 		SimVar.GetSimVarValue("A:RECIP ENG FUEL TANK SELECTOR:1",	"number").toString());
		this.write('ALTERNATE_AIR',		SimVar.GetSimVarValue("A:ALTERNATE STATIC SOURCE OPEN",		"Bool").toString());

		this.write('FLAPS_HANDLE',		SimVar.GetSimVarValue("A:FLAPS HANDLE INDEX", 			"Number").toString());
		this.write('ELEVATOR_TRIM_HANDLE',	SimVar.GetSimVarValue("A:ELEVATOR TRIM INDICATOR", 		"POSITION 16k").toString());
		this.write('KOHLSMAN_SETTING_MB',	SimVar.GetSimVarValue("A:KOHLSMAN SETTING MB", 			"Millibars"   ).toString());

		this.write('THROTTLE_POS',		SimVar.GetSimVarValue("A:GENERAL ENG THROTTLE LEVER POSITION:1","percent").toString());
		this.write('MIXTURE_POS',		SimVar.GetSimVarValue("A:GENERAL ENG MIXTURE LEVER POSITION:1", "percent").toString());

		this.write('FUEL_TANK_L',		SimVar.GetSimVarValue("FUEL TANK LEFT MAIN QUANTITY",  		"gallons").toString());
		this.write('FUEL_TANK_R',		SimVar.GetSimVarValue("FUEL TANK RIGHT MAIN QUANTITY", 		"gallons").toString());
		this.write('STATION2',			SimVar.GetSimVarValue("PAYLOAD STATION WEIGHT:2", 		"pounds" ).toString());
		this.write('STATION3',			SimVar.GetSimVarValue("PAYLOAD STATION WEIGHT:3", 		"pounds" ).toString());
		this.write('STATION4',			SimVar.GetSimVarValue("PAYLOAD STATION WEIGHT:4", 		"pounds" ).toString());

		this.write('SUN_VISOR_left1',		SimVar.GetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left1",	"number").toString());
		this.write('SUN_VISOR_left2',		SimVar.GetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left2",	"number").toString());
		this.write('SUN_VISOR_left3',		SimVar.GetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left3",	"number").toString());
		this.write('SUN_VISOR_left4',		SimVar.GetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left4",	"number").toString());
		this.write('SUN_VISOR_right1',		SimVar.GetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right1",	"number").toString());
		this.write('SUN_VISOR_right2',		SimVar.GetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right2",	"number").toString());
		this.write('SUN_VISOR_right3',		SimVar.GetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right3",	"number").toString());
		this.write('SUN_VISOR_right4',		SimVar.GetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right4",	"number").toString());
		this.write('DOOR_LEFT',			SimVar.GetSimVarValue("L:XML_bagoluC172_Door_left",		"number").toString());
		this.write('DOOR_RIGHT',		SimVar.GetSimVarValue("L:XML_bagoluC172_Door_right",		"number").toString());
		this.write('WINDOW_LEFT',		SimVar.GetSimVarValue("L:XML_bagoluC172_Window_left",		"number").toString());
		this.write('WINDOW_RIGHT',		SimVar.GetSimVarValue("L:XML_bagoluC172_Window_right",		"number").toString());

		this.write('WHEELCHOCKS',		SimVar.GetSimVarValue("L:BAGOLUC172_WHEELCHOCKS",		"bool").toString());
		this.write('BUG',			SimVar.GetSimVarValue("L:BAGOLUC172_GPU_VISIBLE",		"bool").toString());
		this.write('TIEDOWNS',			SimVar.GetSimVarValue("L:BAGOLUC172_TIEDOWNS",			"bool").toString());
		this.write('COVERS',			SimVar.GetSimVarValue("L:BAGOLUC172_COVERS",			"bool").toString());

		this.write('CARDBOARD',			SimVar.GetSimVarValue("L:BAGOLUC172_CARDBOARD",			"bool").toString());
		this.write('MICROPHONE1',		SimVar.GetSimVarValue("L:XML_bagoluC172_Microphone1",		"bool").toString());
	}
	/************************************/
	/* Load cockpit vars		*/
	/*   and set default values if none */
	/************************************/
	STATE_SAVING_load() {
		/* anywhere */
		SimVar.SetSimVarValue("FUEL TANK LEFT MAIN QUANTITY",		"gallons",	Number(this.read("FUEL_TANK_L",  3)));
		SimVar.SetSimVarValue("FUEL TANK RIGHT MAIN QUANTITY",		"gallons",	Number(this.read("FUEL_TANK_R",  3)));
		SimVar.SetSimVarValue("PAYLOAD STATION WEIGHT:2",		"pounds",	Number(this.read("STATION2",   170)));
		SimVar.SetSimVarValue("PAYLOAD STATION WEIGHT:3",		"pounds",	Number(this.read("STATION3",     0)));
		SimVar.SetSimVarValue("PAYLOAD STATION WEIGHT:4",		"pounds",	Number(this.read("STATION4",     0)));

		SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left1",  "number", Number(this.read("SUN_VISOR_left1",  0)));
		SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left2",  "number", Number(this.read("SUN_VISOR_left2",  0)));
		SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left3",  "number", Number(this.read("SUN_VISOR_left3",  0)));
		SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_left4",  "number", Number(this.read("SUN_VISOR_left4",  0)));
		SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right1", "number", Number(this.read("SUN_VISOR_right1", 0)));
		SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right2", "number", Number(this.read("SUN_VISOR_right2", 0)));
		SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right3", "number", Number(this.read("SUN_VISOR_right3", 0)));
		SimVar.SetSimVarValue("L:XMLVAR_bagoluC172_sun_visor_right4", "number", Number(this.read("SUN_VISOR_right4", 0)));

		var leftwindow  = Number(this.read("WINDOW_LEFT",  0));
		var rightwindow = Number(this.read("WINDOW_RIGHT", 0));
		SimVar.SetSimVarValue("L:XML_bagoluC172_Window_left",		  "number", leftwindow);
		SimVar.SetSimVarValue("L:XML_bagoluC172_Window_right",		  "number", rightwindow);
		if (leftwindow > 0)  { SimVar.SetSimVarValue("K:TOGGLE_AIRCRAFT_EXIT_FAST", "Number", 3); }
		if (rightwindow > 0) { SimVar.SetSimVarValue("K:TOGGLE_AIRCRAFT_EXIT_FAST", "Number", 4); }

		SimVar.SetSimVarValue("L:BAGOLUC172_CABIN1", 				"number", Number(this.read("LIGHT_CABIN1",  0)));
		SimVar.SetSimVarValue("L:BAGOLUC172_CABIN2", 				"number", Number(this.read("LIGHT_CABIN2",  0)));
		SimVar.SetSimVarValue("L:BAGOLUC172_LIGHTPANEL1", 			"number", Number(this.read("LIGHT_PANEL1",  0)));
		SimVar.SetSimVarValue("L:BAGOLUC172_LIGHTPANEL2", 			"number", Number(this.read("LIGHT_PANEL2",  0)));
		SimVar.SetSimVarValue("L:BAGOLUC172_LIGHTPANEL3", 			"number", Number(this.read("LIGHT_PANEL3",  0)));

		SimVar.SetSimVarValue("L:BAGOLUC172_CARDBOARD",				"bool", this.read("CARDBOARD",      0) == "1" );
		SimVar.SetSimVarValue("L:XML_bagoluC172_Microphone1",			"bool", this.read("MICROPHONE1",    0) == "1" );

		/* Only on ground, parked */
		if (SimVar.GetSimVarValue("ATC ON PARKING SPOT", "bool") == 1) {
			//
			SimVar.SetSimVarValue("K:ALTERNATOR_SET",		"bool",		this.read("MASTER_ALTERNATOR",	0) == "1");
			SimVar.SetSimVarValue("ELECTRICAL MASTER BATTERY:1",	"bool",		this.read("MASTER_BATTERY",	0) == "1");
			SimVar.SetSimVarValue("ELECTRICAL MASTER BATTERY:2",	"bool",		this.read("BACKUP_BATTERY",	0) == "1");
			SimVar.SetSimVarValue("K:AVIONICS_MASTER_1_SET",	"bool",		this.read("AVIONICS_MASTER_1",	0) == "1");
			SimVar.SetSimVarValue("K:AVIONICS_MASTER_2_SET",	"bool",		this.read("AVIONICS_MASTER_2",	0) == "1");

			SimVar.SetSimVarValue("A:LIGHT BEACON", 		"bool", 	this.read("LIGHT_BEACON",  	0) == "1");
			SimVar.SetSimVarValue("A:LIGHT LANDING", 		"bool",		this.read("LIGHT_LANDING",	0) == "1");
			SimVar.SetSimVarValue("A:LIGHT TAXI", 			"bool",		this.read("LIGHT_TAXI",    	0) == "1");
			SimVar.SetSimVarValue("A:LIGHT NAV", 			"bool",		this.read("LIGHT_NAV",		0) == "1");
			SimVar.SetSimVarValue("A:LIGHT STROBE", 		"bool", 	this.read("LIGHT_STROBE",  	0) == "1");

			SimVar.SetSimVarValue("K:ELECT_FUEL_PUMP1_SET",		"bool",		this.read("FUEL_PUMP",		0) == "1");
			SimVar.SetSimVarValue("K:PITOT_HEAT_SET", 		"bool",		this.read("PITOT_HEAT", 	0) == "1");

			SimVar.SetSimVarValue("L:XMLVAR_YokeHidden1", 		"bool",		this.read("YokeHidden1", 	1) == "1");
			SimVar.SetSimVarValue("L:XMLVAR_YokeHidden2", 		"bool",		this.read("YokeHidden2", 	1) == "1");

			SimVar.SetSimVarValue("K:PARKING_BRAKE_SET", 		"bool",		this.read("PARKING_BREAK", 	1) == "1");
			//SimVar.SetSimVarValue("K:SET_FUEL_VALVE_ENG1",		"bool",		this.read("FUEL_VALVE", 	1) == "1");

			SimVar.SetSimVarValue("K:FUEL_SELECTOR_SET", 		"number",	Number(this.read("FUEL_SELECTOR", 0)));
			if ((this.read("ALTERNATE_AIR", 1)=="1") != (SimVar.GetSimVarValue("A:ALTERNATE STATIC SOURCE OPEN","Bool")==1)) {
				SimVar.SetSimVarValue("K:TOGGLE_ALTERNATE_STATIC",	"bool",	1);
			}
			SimVar.SetSimVarValue("A:FLAPS HANDLE INDEX",		"number",	Number(this.read("FLAPS_HANDLE",	 0)));
			SimVar.SetSimVarValue("K:AXIS_ELEV_TRIM_SET",		"POSITION 16k",	Number(this.read("ELEVATOR_TRIM_HANDLE", 0))-1);
			SimVar.SetSimVarValue("K:KOHLSMAN_SET",			"Millibars",	Number(this.read("KOHLSMAN_SETTING_MB",  1013.2))*16);

			SimVar.SetSimVarValue("A:GENERAL ENG THROTTLE LEVER POSITION:1", "percent",	parseFloat(this.read("THROTTLE_POS", 0)));
			SimVar.SetSimVarValue("A:GENERAL ENG MIXTURE LEVER POSITION:1",  "percent",	parseFloat(this.read("MIXTURE_POS",  0)));

			var leftdoor  = Number(this.read("DOOR_LEFT",  0));
			var rightdoor = Number(this.read("DOOR_RIGHT", 0));
			SimVar.SetSimVarValue("L:XML_bagoluC172_Door_left",				"number", leftdoor);
			SimVar.SetSimVarValue("L:XML_bagoluC172_Door_right",				"number", rightdoor);
			if (leftdoor > 0)  { SimVar.SetSimVarValue("K:TOGGLE_AIRCRAFT_EXIT_FAST",	"Number", 1); }
			if (rightdoor > 0) { SimVar.SetSimVarValue("K:TOGGLE_AIRCRAFT_EXIT_FAST",	"Number", 2); }

			SimVar.SetSimVarValue("L:BAGOLUC172_WHEELCHOCKS",	"bool",		this.read("WHEELCHOCKS", 0) == "1" );
			SimVar.SetSimVarValue("L:BAGOLUC172_GPU_VISIBLE",	"bool",		this.read("GPU",	 0) == "1" );
			SimVar.SetSimVarValue("L:BAGOLUC172_TIEDOWNS",		"bool",		this.read("TIEDOWNS",    0) == "1" );
			SimVar.SetSimVarValue("L:BAGOLUC172_COVERS",		"bool",		this.read("COVERS",      0) == "1" );
		}
	}
	/***************/
	/* KAP140 hack */
	/***************/
	RadioStackSettingKAP140() {
		// WT430/530 need to be on a moment for KAP140 to work but need to be off for TDS to work
		// It has to be done after  L:AutopoilotPreflightCheckCompleted = 1
		var kapboot = SimVar.GetSimVarValue("L:AutopilotPreflightCheckCompleted","Bool");
		if (this.kap140wait && SimVar.GetSimVarValue("L:AutopilotPreflightCheckCompleted","Bool")) {
		    this.kap140wait = 0;
		    SimVar.SetSimVarValue("L:XMLVAR_GPS_DISABLED_AS430_1", "Bool", (this.radiostack!=3));
		}
	}
	/*************************************/
	/* Initialiaze radios stacks     */
	/*************************************/
	RadioStackSetting() {
		SimVar.SetSimVarValue("L:BAGOLUC172_RADIOSTACK", "number", this.radiostack);
		SimVar.SetSimVarValue("L:TDSGTNXI_InactiveVar", "Bool", (this.radiostack!=4));
		SimVar.SetSimVarValue("L:XMLVAR_GPS_DISABLED_GTN750", "Bool", (this.radiostack!=5));
		SimVar.SetSimVarValue("L:KLN90B_Disabled", "Bool", (this.radiostack!=2));
		SimVar.SetSimVarValue("L:XMLVAR_GPS_DISABLED_AS530_1", "Bool", 1);
		// See RadioStackSettingKAP140()
		if (this.kap140wait == 0) {
		    SimVar.SetSimVarValue("L:XMLVAR_GPS_DISABLED_AS430_1", "Bool", (this.radiostack!=3));
		} else {
		    SimVar.SetSimVarValue("L:XMLVAR_GPS_DISABLED_AS430_1", "Bool", 0);
		}
	}
	/*****************/
	/* Buttons press */
	/*****************/
	GOTOPAGEA_Press() {
		if (this.page > 0) { this.page--; }
	}
	GOTOPAGEB_Press() {
		if (this.page < 2) { this.page++; }
	}
	GOTOPAGEZ_Press() {
		this.page = 9;
	}
	HIDE_MANUAL_LOGO_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_HIDE_MANUAL_LOGO", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_HIDE_MANUAL_LOGO", "Bool") == 0));
	}
	PANEL_COVER_Press() {
		var previous = SimVar.GetSimVarValue("L:BAGOLUC172_PANEL_COVER", "Bool");
		SimVar.SetSimVarValue("L:BAGOLUC172_PANEL_COVER", "Bool", previous == 0);
	}
	PILOTVISIBLE_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_PILOT_VISIBLE", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_PILOT_VISIBLE", "Bool") == 0));
	}
	COPILOTVISIBLE_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_COPILOT_VISIBLE", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_COPILOT_VISIBLE", "Bool") == 0));
	}
	LEFTPASSENGER_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_LEFTPASSENGER", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_LEFTPASSENGER", "Bool") == 0));
	}
	RIGHTPASSENGER_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_RIGHTPASSENGER", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_RIGHTPASSENGER", "Bool") == 0));
	}
	BACKSEATS_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_BACK_SEATS", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_BACK_SEATS", "Bool") == 0));
	}
	FRONTRIGHTSEAT_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_FRONT_RIGHT_SEAT", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_FRONT_RIGHT_SEAT", "Bool") == 0));
	}
	FRONTFAIRINGS_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_FAIRINGS_FRONT", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_FAIRINGS_FRONT", "Bool") == 0));
	}
	BACKFAIRINGS_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_FAIRINGS_BACK", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_FAIRINGS_BACK", "Bool") == 0));
	}
	BUTTONSLIST_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_BUTTONSLIST", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_BUTTONSLIST", "Bool") == 0));
	}
	CARDLIST_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_CARDLIST", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_CARDLIST", "Bool") == 0));
	}
	WHEELCHOCKS_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_WHEELCHOCKS", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_WHEELCHOCKS", "Bool") == 0));
	}
	GPU_Press() {
		var gpu = SimVar.GetSimVarValue("L:BAGOLUC172_GPU_VISIBLE", "Bool");
		SimVar.SetSimVarValue("L:BAGOLUC172_GPU_VISIBLE", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_GPU_VISIBLE", "Bool") == 0));

		if (SimVar.GetSimVarValue("A:EXTERNAL POWER ON:1", "Bool") == gpu) {
			SimVar.SetSimVarValue("K:TOGGLE_EXTERNAL_POWER", "bool", 1);
		}
	}
	TIEDOWNS_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_TIEDOWNS", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_TIEDOWNS", "Bool") == 0));
	}
	COVERS_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_COVERS", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_COVERS", "Bool") == 0));
	}
	VARIOUSSTUFF_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_VARIOUSSTUFF", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_VARIOUSSTUFF", "Bool") == 0));
	}
	COMPASS0_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_COMPASS1", "bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_COMPASS2", "bool", 0);
	}
	COMPASS1_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_COMPASS1", "bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_COMPASS2", "bool", 0);
	}
	COMPASS2_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_COMPASS1", "bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_COMPASS2", "bool", 1);
	}
	FDGYRO_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_FDGYRO", "bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_FDHSI", "bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_FDG5", "bool", 0);
	}
	FDHSI_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_FDGYRO", "bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_FDHSI", "bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_FDG5", "bool", 0);
	}
	FDG5_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_FDGYRO", "bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_FDHSI", "bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_FDG5", "bool", 1);
	}
	HZSTD_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_HZSTD", "bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_HZG5", "bool", 0);
	}
	HZG5_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_HZSTD", "bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_HZG5", "bool", 1);
	}
	AOA_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_AOA_VISIBLE", "bool", (SimVar.GetSimVarValue("L:BAGOLUC172_AOA_VISIBLE", "Bool") == 0));
	}
	RSVFR_Press() {
		this.radiostack = 0;
		this.RadioStackSetting();
	}
	RSRADIOS_Press() {
		this.radiostack = 1;
		this.RadioStackSetting();
	}
	RSKLN90B_Press() {
		this.radiostack = 2;
		this.RadioStackSetting();
	}
	RSG430_Press() {
		this.radiostack = 3;
		this.RadioStackSetting();
	}
	RSTDS750_Press() {
		this.radiostack = 4;
		this.RadioStackSetting();
	}
	RSPMS750_Press() {
		this.radiostack = 5;
		this.RadioStackSetting();
	}
	CARGO_BAGS_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_BAGS", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_BAGS", "Bool") == 0));
	}
	CARGO_LUGGAGE_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LUGGAGE", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LUGGAGE", "Bool") == 0));
	}
	CARGO_L_EMPTY_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES", "Bool", 0);
	}
	CARGO_R_EMPTY_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES", "Bool", 0);
	}
	CARGO_LR_CAMPING_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES", "Bool", 0);
	}
	CARGO_L_CRATES_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES", "Bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES", "Bool", 0);
	}
	CARGO_R_CRATES_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES", "Bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES", "Bool", 0);
	}
	CARGO_L_CBBOXES_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES", "Bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES", "Bool", 0);
	}
	CARGO_R_CBBOXES_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES", "Bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES", "Bool", 0);
	}
	CARGO_L_TANKS_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS", "Bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES", "Bool", 0);
	}
	CARGO_R_TANKS_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS", "Bool", 1);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES", "Bool", 0);
	}
	CARGO_L_FCASES_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_FCASES", "Bool", 1);
	}
	CARGO_R_FCASES_Press() {
		if (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", 	"Bool") == 1) {
			SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_L_EMPTY", "Bool", 1);
		}
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_EMPTY", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_LR_CAMPING", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CRATES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_CBBOXES", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_TANKS", "Bool", 0);
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_R_FCASES", "Bool", 1);
	}
	UNLOAD_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_CARGO_UNLOAD", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_CARGO_UNLOAD", "Bool") == 0));
	}

	ROOFWINDOWS_Press() {
		SimVar.SetSimVarValue("L:BAGOLUC172_ROOFWINDOWS", "Bool", (SimVar.GetSimVarValue("L:BAGOLUC172_ROOFWINDOWS", "Bool") == 0));
	}
}
/***************/
/* Registering */
/***************/
registerInstrument("bagoluc172_book-element", bagoluc172_book);
